﻿namespace Hims.Api.Helper
{
    using System;
    using System.Linq;
    using System.Security.Cryptography;
    using System.Text;   
    using Hims.Domain.Services;

    /// <summary>
    /// The payment helper.
    /// </summary>
    public static class PaymentHelper
    {
        /// <summary>
        /// The generate check sum hash.
        /// </summary>
        /// <param name="text">
        /// The text.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>

        public static string GenerateCheckSumHash(string text)
        {
            var message = Encoding.UTF8.GetBytes(text);
            var hashString = new SHA256Managed();
            var hashValue = hashString.ComputeHash(message);
            return hashValue.Aggregate(string.Empty, (current, x) => current + $"{x:x2}");
        }

        /// <summary>
        /// The generate hash.
        /// </summary>
        /// <param name="text">
        /// The text.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        public static string GenerateHash(string text)
        {
            var message = Encoding.UTF8.GetBytes(text);
            var hashString = new SHA512Managed();
            var hashValue = hashString.ComputeHash(message);
            return hashValue.Aggregate(string.Empty, (current, x) => current + $"{x:x2}");
        }

        ///// <summary>
        ///// The generate transaction id.
        ///// </summary>
        ///// <returns>
        ///// The <see cref="string"/>.
        ///// </returns>
        //public static string GenerateTransactionId()
        //{
        //    var rnd = new Random();
        //    var strHash = GenerateHash(rnd.ToString() + DateTime.UtcNow);
        //    return strHash.Substring(0, 20);
        //}

        /// <summary>
        /// The generate transaction id.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>

        public static  string GetVouherNumber(IAppointmentTransactionService appointmentTransactionsServices)
        {
           // var previous =  unitOfWork.Current.QuerySingleOrDefaultAsync<string>($@"select ""VoucherNumber"" from ""AppointmentTransaction"" order by ""AppointmentTransactionId"" desc limit 1");
            var previousVoucherNo =  appointmentTransactionsServices.GetPreviousVoucherNumberAsync();

            if (previousVoucherNo == null)
            {
               
                return $@"{DateTime.Now.ToString("dd/MM/yy")}/10001";
            }
            else
            {
                var preVoucherno = previousVoucherNo.ToString(); // converting in string
                var prevoucherdate = preVoucherno.Substring(0, Math.Min(preVoucherno.Length, 8)); //DateTime in string


                if (prevoucherdate != DateTime.Now.ToString("dd/MM/yy"))
                {
                    return $@"{DateTime.Now.ToString("dd/MM/yy")}/10001"; // start seq for new date .
                }
                else
                {
                    var presequenceNo = preVoucherno.Substring(preVoucherno.Length - 5);    //  increment seq for same date .
                    return $@"{DateTime.Now.ToString("dd/MM/yy")}/{Convert.ToInt64(presequenceNo) + 1}";
                }
            }
                
        }


    }
}
